package gov.va.med.mhv.calendar.validator;

import gov.va.med.mhv.calendar.dto.UserCalViewDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.util.LinkedHashMap;

import org.springframework.stereotype.Component;


@Component
public class PreferencesValidator extends Validator {
	
	private static final String PREF_ZIPCODE="Zip Code";
	private static final String INVALID_ZIP_CODE="Invalid Zip code";
	private static final String NON_NUMERIC_ZIP_CODE="Non numeric Zip code";
	
	public ResponseUtil<UserCalViewDTO> fieldValidations(UserCalViewDTO userCalViewDTO, Boolean zipCodeFound) {
		ResponseUtil<UserCalViewDTO> response = new ResponseUtil<UserCalViewDTO>();
		
		LinkedHashMap<String, String> validationErrors = new LinkedHashMap<String, String>();
		validateFields(userCalViewDTO,zipCodeFound, validationErrors);
	
		response.setValidationErrors(validationErrors);
	
		return response;
		
	}
	

	private void validateFields(UserCalViewDTO userCalViewDTO, Boolean zipCodeFound, LinkedHashMap<String, String> validationErrors) {
			

		
		
		if (userCalViewDTO.getZipCode() != null )  { 
			
			if (!zipCodeFound){
			
		    	validationErrors.put(INVALID_ZIP_CODE, "Your zip code does not match a region in our system. Please re-enter your 5 digit zip code, or leave the field blank and click &#34;Save.&#34;  If you leave the field blank, your calendar will not display VHA Events associated with your zip code.");
			}
			
			if (userCalViewDTO.getZipCode().matches("[a-zA-Z]+"))  {
				validationErrors.put(NON_NUMERIC_ZIP_CODE, "The zip code must contain only numbers."); 
			}
		}
		
		if (userCalViewDTO.getZipCode() != null && userCalViewDTO.getZipCode().length() != 5 && userCalViewDTO.getZipCode().length() > 0 ) {
			
			validationErrors.put(PREF_ZIPCODE,"The zip code must contain 5 numbers.");
			
		}

	}
	
}


